<?php

class pluginCodeHighlightShiki extends Plugin {
  public function siteBodyEnd() {
    $theme = 'one-dark-pro';
    $javascript_code = <<<JS
    <script type="module">
      import { codeToHtml } from 'https://esm.sh/shiki@1.22.2';

      document.addEventListener("DOMContentLoaded", async () => {
        // <code>タグ内のコードをハイライト
        document.querySelectorAll('pre code').forEach(async (codeElement) => {
          const codeText = codeElement.textContent;

          // class属性から言語とファイル名を取得
          const classList = codeElement.classList;
          const languageClass = classList.value.match(/language-([^:]+)/);
          const lang = languageClass ? languageClass[1] : 'text';

          const highlightedCode = await codeToHtml(codeText, { 
            lang,
            theme: '$theme'
          });

          // <code>タグの内容をハイライト済みのHTMLに置き換え
          const preElement = codeElement.parentNode;
          preElement.outerHTML = highlightedCode;
        });
      });
    </script>
    JS;

    echo $javascript_code;
  }
}
