<?php
// pluginCodeHighlightShiki
class pluginCodeHighlightShiki extends Plugin {

  public function init() {
    $this->dbFields = array(
      'theme' => 'one-dark-pro'
    );
  }

  public function siteBodyEnd() {
    $theme = $this->getValue('theme');
    $javascript_code = <<<JS
    <script type="module">
      // wait for loading (Inherited legacy)
      document.addEventListener("DOMContentLoaded", async () => {
        // import only when <code> exists
        if (document.querySelector("code")) {
          import('https://esm.sh/shiki@1.22.2').then(({ codeToHtml }) => {

            document.querySelectorAll('pre code').forEach(async (codeElement) => {
              const codeText = codeElement.textContent;

              // class属性から言語とファイル名を取得
              const classList = codeElement.classList;
              const languageClass = classList.value.match(/language-([^:]+)/);
              const lang = languageClass ? languageClass[1] : 'text';

              const highlightedCode = await codeToHtml(codeText, { 
                lang,
                theme: '$theme'
              });

              // <code>タグの内容をハイライト済みのHTMLに置き換え
              const preElement = codeElement.parentNode;
              preElement.outerHTML = highlightedCode;
            });
          });
        };
      });
    </script>
    JS;

    echo $javascript_code;
  }

  /*
    admin panel
  */
  public function form() {
    $html .= '<div class="form-group">';
      $html .= '<lable for="selectShikiTheme">Select Theme</lable>';
      $html .= '<select id="shiki-theme-selecter" name="theme"></select>';
    $html .= '</div>';
    $html .= '<script type="module">';
      $html .= 'import("https://esm.sh/shiki@1.22.2").then(async ({ bundledThemes, createHighlighter }) => {';

        $html .= 'const highlighter = await createHighlighter({';
          $html .= 'themes: Object.keys(bundledThemes)';
        $html .= '});';
        $html .= 'const selectThemeElement = document.getElementById("shiki-theme-selecter");';

        $html .= 'const themes = Object.keys(bundledThemes);';
        $html .= 'themes.forEach(item => {';
          $html .= 'const option = document.createElement("option");';
          $html .= 'option.value = item;';
          $html .= 'option.text = item;';
          $html .= 'selectThemeElement.appendChild(option);';
        $html .= '});';
        $html .= 'for (let i = 0; i < selectThemeElement.options.length; i++) {';
          $html .= 'if (selectThemeElement.options[i].value === "' . $this->getValue("theme") .'") {';
            $html .= 'selectThemeElement.options[i].selected = true;';
            $html .= 'break;';
          $html .= '}';
        $html .= '}';
      $html .= '});';
    $html .= '</script>';

    return $html;
  }
}